%% This script takes the result from Polyakov Vertex Model as input
clear all; close all; clc;

k = 111; % simulation ID

loadfile_path = [pwd, '/Simulation', num2str(k),'/'];
if ~exist(loadfile_path)
    disp(['Simulation', num2str(k), ' does not exist.']);
end

v = VideoWriter(['Movie/Simulation', num2str(k)]);
open(v);

for hh = 1:1000
    
    loadfile = [loadfile_path, 'Stage', num2str(hh),'.mat'];
    if ~exist(loadfile)
        break;
    end
    
    load(loadfile);
    
    Td = size(Vxm,2);
    
    M_tmp = [];
    
    if hh == 1
        t_sel = [1,Td];
    else
        t_sel = Td;
    end
    
    for t = t_sel%1:t_sel(end)%
        Vxm_tmp = Vxm{t};
        Vym_tmp = Vym{t};
        N = size(Vxm_tmp,2);
        
        Axn = Vxm_tmp(1,:); Axn = [Axn,Axn(1)];
        Ayn = Vym_tmp(1,:); Ayn = [Ayn,Ayn(1)];
        Bxn = Vxm_tmp(2,:); Bxn = [Bxn,Bxn(1)];
        Byn = Vym_tmp(2,:); Byn = [Byn,Byn(1)];
        
        h = figure('Position', [300 30 800 800]); hold on; axis equal;
        plot(Axn, Ayn, 'r-*', 'linewidth', 2);
        plot(Bxn, Byn, 'b-*', 'linewidth', 2);
        for i=1:N, plot([Axn(i) Bxn(i)], [Ayn(i) Byn(i)], 'k', 'linewidth', 2);end
        hold off;
        title(['Step = ', num2str(hh), '(', num2str(t),')']);
        drawnow; pause(.1);
        
        M_tmp = getframe(h);
        writeVideo(v,M_tmp);
        close;
    end
end
close(v);